/* ###.cpp */

#include "BOLTApp.h"
#include "db/BOLTdb.h"
#include "db/BOLTdbConfig.h"
#include "ctrl/BOLTControls.h"
#include "ctrl/BOLTChooser.h"
#include "ctrl/BOLTUser.h"
//#include "ctrl/BOLTReport.h"
//#include "report/brRunner.h"
#include "BOLTFrm.h"

wxString BOLTDB_title,BOLTDB_host,BOLTDB_database,BOLTDB_user,BOLTDB_pass,BOLTDB_port;


// BdbConfigEdit - Edit a database entry

enum { 
	ID_EDIT = 23666,
		ID_NEW,
		ID_DELETE,
		ID_DBLIST,
		ID_OK,
		ID_CANCEL
};



class BdbConfigEdit  : public wxDialog
{
//	DECLARE_DYNAMIC_CLASS(BdbConfigEdit)
public:
	wxTextCtrl *tTitle,*tHost,*tUser,*tPass,*tPort,*tDB;
		  myConfig *config;

		  int entry;

	BdbConfigEdit(int entry,wxWindow *parent,myConfig *conf) : 
		wxDialog(parent,-1,"Database Settings",wxDefaultPosition)
		{
			config=conf;
			this->entry = entry;
		  wxString str,key;
#define BCEBUILD(t,v,s) \
		  key.Printf("%u/%s",entry,t); \
		  if ( !config->Read(key, &str) ) {  str="";}  \
		  v = new wxTextCtrl(this,-1,str,wxDefaultPosition,wxDefaultSize,s);
		BCEBUILD("Title",tTitle,0);
		BCEBUILD("Host",tHost,0);
		BCEBUILD("Port",tPort,0);
		BCEBUILD("Database",tDB,0);
		BCEBUILD("User",tUser,0);
		BCEBUILD("Pass",tPass,wxTE_PASSWORD);
		wxGridSizer *tSizer = new wxGridSizer(0,2,5,5);
		tSizer->Add(new wxStaticText(this,-1,"Title"));
		tSizer->Add(tTitle);
		tSizer->Add(new wxStaticText(this,-1,"Server"));
		tSizer->Add(tHost);
		tSizer->Add(new wxStaticText(this,-1,"Port"));
		tSizer->Add(tPort);
		tSizer->Add(new wxStaticText(this,-1,"Database"));
		tSizer->Add(tDB);
		tSizer->Add(new wxStaticText(this,-1,"Username"));
		tSizer->Add(tUser);
		tSizer->Add(new wxStaticText(this,-1,"Password"));
		tSizer->Add(tPass);
		tSizer->Add(new wxButton(this,ID_OK,"Save"));
		tSizer->Add(new wxButton(this,ID_CANCEL,"Cancel"));
//		SetAutoLayout(TRUE);
		SetSizerAndFit(tSizer);
		tSizer->Fit(this);
		tSizer->SetSizeHints(this);
		ShowModal();
		Destroy();
		}

	void OnbOK(wxCommandEvent& event)
	{
		  wxString str,key;
#define BCE_CFG_WRITE(k,v)	\
		  key.Printf("%u/%s",entry,k); \
		  if ( !config->Write(key, v->GetValue()) ) {; };  


		
		BCE_CFG_WRITE("Title",tTitle);
		BCE_CFG_WRITE("Host",tHost);
		BCE_CFG_WRITE("Database",tDB);
		BCE_CFG_WRITE("User",tUser);
		BCE_CFG_WRITE("Pass",tPass);
		BCE_CFG_WRITE("Port",tPort);
		config->Flush(FALSE);
		EndModal(0);
	}
	void OnbCancel(wxCommandEvent& event)
	{
		EndModal(0);
	}
virtual void Dump(ostream& stream) 
	{	stream << "Dump : bcConfigEdit"; }

	DECLARE_EVENT_TABLE()
};


//IMPLEMENT_DYNAMIC_CLASS(BdbConfigEdit, wxDialog)
BEGIN_EVENT_TABLE(BdbConfigEdit, wxDialog)
EVT_BUTTON(ID_OK,BdbConfigEdit::OnbOK)
EVT_BUTTON(ID_CANCEL,BdbConfigEdit::OnbCancel)
END_EVENT_TABLE()

//IMPLEMENT_DYNAMIC_CLASS(BdbConfig, wxDialog)
BEGIN_EVENT_TABLE(BdbConfig, wxDialog)
EVT_BUTTON(ID_OK,BdbConfig::OnbOK)
EVT_BUTTON(ID_EDIT,BdbConfig::OnbEdit)
EVT_BUTTON(ID_NEW,BdbConfig::OnbNew)
EVT_BUTTON(ID_DELETE,BdbConfig::OnbDelete)
EVT_LIST_ITEM_ACTIVATED(ID_DBLIST,BdbConfig::OnbActivate) 
END_EVENT_TABLE()
BdbConfig::BdbConfig(wxWindow *parent) :
		wxDialog(parent,-1,"Choose Database",wxDefaultPosition,wxDefaultSize,/*wxDIALOG_MODAL |*/ wxDEFAULT_DIALOG_STYLE)
		{
			wxButton *bOk;
			config=wxGetApp().config;
			config->SetPath("/Databases");
			isSetup=FALSE;
			wxBoxSizer *fSizer = new wxBoxSizer(wxVERTICAL);
			listCtrl = new wxListCtrl(this,ID_DBLIST,wxDefaultPosition,wxSize(200,100),
				wxLC_ICON|wxLC_SINGLE_SEL);
			tImageList = new wxImageList(64,64,TRUE,1);
			tImageList->Add(BITMAP_DB,BITMASK_DB);
			listCtrl->SetImageList(tImageList,wxIMAGE_LIST_NORMAL);
		
			wxBoxSizer *bSizer = new wxBoxSizer(wxHORIZONTAL);
			fSizer->Add(listCtrl,1,wxEXPAND,20);
			bSizer->Add(bOk=new wxButton(this,ID_OK,"&Ok"),0,wxALL,5);
			bSizer->Add(bNew=new wxButton(this,ID_NEW,"&Setup >>"),0,wxALL,5);
			bSizer->Add(bEdit=new wxButton(this,ID_EDIT,"&Edit"),0,wxALL,5);
			bSizer->Add(bDelete=new wxButton(this,ID_DELETE,"&Quit"),0,wxALL,5);
			fSizer->Add(bSizer,0,wxEXPAND,20);
//			this->SetAutoLayout(TRUE);
			this->SetSizerAndFit(fSizer);
			fSizer->Fit(this);
			fSizer->SetSizeHints(this);

			bEdit->Show(FALSE);
//			bDelete->Show(FALSE);
			isSetup=FALSE;
			//ImageList
			FillList();
			CenterOnParent();	
			bOk->SetFocus();
		}
		BdbConfig::~BdbConfig()
		{
			safe_delete(this->tImageList);
//			delete config;
		}
	BOLTdb *BdbConfig::GetDatabase()
		{
		int entry;
		config->SetPath("/Databases");
		while (1)
		{
		entry=this->ShowModal();
			wxString title,host,db,user,pass,port;
			unsigned long iPort;
			wxString str,key;
	#define BCGRAB(t,s,bdb) \
			  key.Printf("%u/%s",entry,t); \
			if ( !config->Read(key, &s) ) {  s="";} \
			bdb = s;

			BCGRAB("Title",title,BOLTDB_title);
			BCGRAB("Host",host,BOLTDB_host);
			BCGRAB("Database",db,BOLTDB_database);
			BCGRAB("User",user,BOLTDB_user);
			BCGRAB("Pass",pass,BOLTDB_pass);
			BCGRAB("Port",port,BOLTDB_port);
			if (!port.ToULong(&iPort)) { iPort=0; }
			BOLTdb *tDB=createBOLTdb((char *)host.c_str(),(char *)db.c_str(),(char *)user.c_str(),(char *)pass.c_str(),iPort);
//			BOLTdb *tDB=new BOLTdb((char *)host.c_str(),(char *)db.c_str(),(char *)user.c_str(),(char *)pass.c_str(),iPort);
			
			if (tDB->Connected()) 
				{ return tDB; }
			else { wxBell(); return tDB; }
		}
	}

	void  BdbConfig::FillList()
	{
		 wxString title,key;
		 long item;
		 listCtrl->DeleteAllItems();
		 for (int i=config->GetNumberOfGroups()-1; i>=0; i--)
		 {
			 key.Printf("%u/Title",i);
			 config->Read(key,&title);
			 item=listCtrl->InsertItem(0,title,0);
			 listCtrl->SetItemText(item,title);
			 if (i==0)
				{
				 listCtrl->SetItemState(item,wxLIST_STATE_SELECTED,wxLIST_STATE_SELECTED);
				}
		 }
	}

	void BdbConfig::OnbActivate(wxListEvent& event)
	{
		if (isSetup)
		{
			BdbConfigEdit *editDlg;
			editDlg = new BdbConfigEdit(event.GetIndex(),this,config);
		} else {
			EndModal(event.GetIndex());
		}
	}
	void BdbConfig::OnbOK(wxCommandEvent& event)
	{
		if (isSetup)
		{
			isSetup=FALSE;
			bNew->SetLabel("&Setup >>");
			SetTitle("Choose Database");
			bEdit->Show(FALSE);
			bDelete->SetLabel("&Quit");
			FillList();
		} else
		{
		long entry;
		entry = listCtrl->GetNextItem(-1,
									 wxLIST_NEXT_ALL,
									 wxLIST_STATE_SELECTED);
	  
		if (entry>=0) {
		EndModal(entry);
		} else { wxBell(); }
		}
	}
 bool BdbConfig::OnCloseWindow(wxCloseEvent& evt)
	{
		long entry;
		entry = listCtrl->GetNextItem(-1,
									 wxLIST_NEXT_ALL,
									 wxLIST_STATE_SELECTED);
	  
		if (entry>=0) {
		return(TRUE);
		} else { evt.Veto(); return(FALSE); }
	}
	void BdbConfig::OnbNew(wxCommandEvent& event)
	{
		if (!isSetup)
		{
			isSetup=TRUE;
			bNew->SetLabel("&New");
			SetTitle("Database Setup");
			bEdit->Show(TRUE);
//			bDelete->Show(TRUE);
			bDelete->SetLabel("&Delete");
		}
		else
		{
		//BdbConfigEdit *editDlg = 
			new BdbConfigEdit(config->GetNumberOfGroups(),this,config);
		FillList();
		}
	}
	void BdbConfig::OnbEdit(wxCommandEvent& event)
	{
		long entry;
		entry = listCtrl->GetNextItem(-1,
									 wxLIST_NEXT_ALL,
									 wxLIST_STATE_SELECTED);
	  
		if (entry>=0) {
//		BdbConfigEdit *editDlg; 
			new BdbConfigEdit(entry,this,config);
		} else { wxBell(); }
		FillList();
	}
	void BdbConfig::OnbDelete(wxCommandEvent& event)
	{
		if (!isSetup)
		{
			BOLTFrame *tWindow;
			tWindow=(BOLTFrame *)(wxGetApp().GetTopWindow());
			tWindow->Close(TRUE);
			EndModal(0);
		}
		else
		{
		 wxString t,t1;
		int entry = listCtrl->GetNextItem(-1,
									 wxLIST_NEXT_ALL,
									 wxLIST_STATE_SELECTED);
	  //TODO FIX BUG
		if (entry>=0) {
			t.Printf("%u",entry);
			unsigned int max = config->GetNumberOfGroups();
		 config->DeleteGroup(t);
		 for (unsigned int i=entry+1; i < max; i++)
		 {
			 t.Printf("%u",i);
			 t1.Printf("%u",i-1);
			config->RenameGroup(t,t1);
		 }
		config->Flush(FALSE);
		} else { wxBell(); }
		FillList();
		}
	}
	   



wxString BdbConfig::GetTitle()
{
return BOLTDB_title;
}
